<?php
require_once __DIR__ . '/config.php';


$url = 'https://www.norgren.com/us/en/list';
$page = get_contents($url);
@$dom->loadHTML($page);


// begin categories
$counter = 0;
$title = $description = $image = $image_save_path = $target = [];


// target
foreach ($dom->getElementsByTagName('a') as $a) {
  if ($a->getAttribute('class') !== 'btn btn-sm more-info') continue;
  $url = $a->getAttribute('href');
  $url = $site . $url;
  array_push($target, $url);
  $counter++;
}

// title, description
foreach ($dom->getElementsByTagName('div') as $div) {
  if ($div->getAttribute('class') !== 'top-text') continue;
  array_push($title, trim($div->childNodes[1]->textContent));
  array_push($description, trim($div->childNodes[3]->textContent));
}

// image, image_save_path
foreach ($dom->getElementsByTagName('img') as $img) {
  if ($img->getAttribute('class') !== 'img-responsive product-image') continue;
  $src = 'https:' . trim($img->getAttribute('src'));
  $save_path = 'img/' . pathinfo($src)['basename'];
  array_push($image, $src);
  array_push($image_save_path, $save_path);
}

//*
// categories database IO
for ($i = 0; $i < $counter; $i++) {
  $stmt = $conn->prepare('SELECT `id` FROM `categories` WHERE `title`=? AND `target`=?'); // check record for decide update or insert
  $stmt->execute([$title[$i], $target[$i]]);
  if ($stmt->rowCount() > 0) {
    $stmt = $conn->prepare('UPDATE `categories` SET `title`=?, `description`=?, `image`=?, `image_save_path`=?, `target`=? WHERE `target`=?');
    if (!$stmt->execute([$title[$i], $description[$i], $image[$i], $image_save_path[$i], $target[$i], $target[$i]]))
      die('خطا حین به روزرسانی دسته بندی ها - خط ' . __LINE__);
  } else {
    $stmt = $conn->prepare('INSERT INTO `categories`(`title`,`description`,`image`,`image_save_path`,`target`) VALUES(?,?,?,?,?)');
    if (!$stmt->execute([$title[$i], $description[$i], $image[$i], $image_save_path[$i], $target[$i]]))
      die('خطا حین افزودن دسته بندی ها به دیتابیس - خط ' . __LINE__);
  }
  $record++;
} //*/
echo ('دسته بندی ها با موفقیت اضافه شدند!' . '<br>');

echo ($record . ' record added to database' . '<br>');