<?php
require_once __DIR__ . '/config.php';


// $conn->beginTransaction();


try {
  // categories
  $conn->query(
    "CREATE TABLE IF NOT EXISTS `categories` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image_save_path` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `target` text COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`)
   ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci"
  );


  // subcategories
  $conn->query(
    "CREATE TABLE IF NOT EXISTS `subcategories` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `parent_category` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image_save_path` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `target` text COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`)
   ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci"
  );


  // products_list
  $conn->query(
    "CREATE TABLE IF NOT EXISTS `products_list` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `parent_category` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image_save_path` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `price` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `currency_sign` text COLLATE utf8mb4_unicode_ci default NULL,
    `target` text COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`)
   ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci"
  );


  // product
  $conn->query(
    "CREATE TABLE IF NOT EXISTS `product` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `parent_category` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `title` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `code` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `image_save_path` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `pdf` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `pdf_save_path` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
    `details` text COLLATE utf8mb4_unicode_ci NOT NULL,
    PRIMARY KEY (`id`)
   ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci"
  );


//   $res = $conn->commit();

  die('<h1 dir="rtl">' . (true ? 'پایگاه داده با موفقیت نصب شد!' : 'خطا در نصب پایگاه داده') . '</h1>');
} catch (PDOException $e) {
//   $conn->rollBack();
  die('Error: <strong>' . $e->getMessage() . '</strong> in file <strong>' . $e->getFile() . '</strong> on <strong>line ' . $e->getLine() . '</strong>');
}
