<?php
require_once __DIR__ . '/config.php';


$prods = $conn->query('SELECT `title`,`target` FROM `products_list` ORDER BY `id` ASC')->fetchAll();


foreach ($prods as $key => $product) {
  try {
    $counter = 0;
    $title = $code = $image = $image_save_path = $content = $pdf = $pdf_save_path = $details = '';


    $page = get_contents($product['target']);
    @$dom->loadHTML($page);

    // image, image_save_path
    foreach ($dom->getElementsByTagName('img') as $img) {
      if ($img->getAttribute('class') !== 'print-only-product-image') continue;
      $src = trim($img->getAttribute('src'));
      $save_path = 'img/' . pathinfo($src)['basename'];
      $image = $src;
      $image_save_path = $save_path;
    }

    // code
    foreach ($dom->getElementsByTagName('span') as $span) {
      if ($span->getAttribute('class') !== 'sku') continue;
      $code = trim($span->nodeValue);
      $counter++;
    }

    // content
    foreach ($dom->getElementsByTagName('ul') as $ul) {
      if ($ul->getAttribute('class') !== 'features') continue;
      foreach ($ul->childNodes as $li) {
        $content = trim($li->nodeValue);
      }
    }

    // title, pdf, pdf_save_path
    $arr = $arr_save_path = [];
    foreach ($dom->getElementsByTagName('div') as $div) {
      $class = $div->getAttribute('class');
      // title
      if ($class === 'product-details col-xs-12 col-sm-8 col-md-9') {
        $title = trim($div->childNodes[1]->nodeValue);
      }
      // pdf, pdf_save_path
      if ($class === 'pdf-link product-detail-link') {
        foreach ($div->childNodes as $child) {
          if ($child->nodeName !== 'a') continue;
          if (preg_match('/\'(.*)\'/im', $child->getAttribute('onclick'), $matches)) {
            $src = trim($matches[1]);
            $save_path = 'upload/' . pathinfo($src)['basename'];
            array_push($arr, $src);
            array_push($arr_save_path, $save_path);
          }
        }
      }
    }
    $pdf = json_encode($arr);
    $pdf_save_path = json_encode($arr_save_path);
    
    // details
    $arr = [];
    foreach ($dom->getElementsByTagName('table')[1]->firstChild->childNodes as $k => $tr) {
      if ($k === 0) continue;
      $arr[trim($tr->firstChild->nodeValue, ': ')] = $tr->lastChild->nodeValue;
    }
    $details = json_encode($arr);

    //*
    // product database IO
    $stmt = $conn->prepare('SELECT `id` FROM `product` WHERE `title`=? AND `code`=?'); // check record for decide update or insert
    $stmt->execute([$title, $code]);
    if ($stmt->rowCount() > 0) {
      $stmt = $conn->prepare('UPDATE `product` SET `parent_category`=?,`title`=?,`code`=?,`image`=?,`image_save_path`=?,`pdf`=?,`pdf_save_path`=?,`content`=?,`details`=? WHERE `code`=?');
      if (!$stmt->execute([$product['title'], $title, $code, $image, $image_save_path, $pdf, $pdf_save_path, $content, $details, $code]))
        die('خطا حین به روزرسانی لیست محصولات - خط ' . __LINE__);
    } else {
      $stmt = $conn->prepare('INSERT INTO `product`(`parent_category`,`title`,`code`,`image`,`image_save_path`,`pdf`,`pdf_save_path`,`content`,`details`) VALUES(?,?,?,?,?,?,?,?,?)');
      if (!$stmt->execute([$product['title'], $title, $code, $image, $image_save_path, $pdf, $pdf_save_path, $content, $details]))
        die('خطا حین افزودن لیست محصولات به دیتابیس - خط ' . __LINE__);
    }
    $record++; //*/
  } catch (Exception $e) {
    continue;
  }
}

echo 'محصول با موفقیت افزوده شد!' . '<br>';

echo ($record . ' record added to database' . '<br>');
