<?php
require_once __DIR__ . '/config.php';


$prods = $conn->query('SELECT `title`,`target` FROM `subcategories` ORDER BY `id` ASC')->fetchAll();


foreach ($prods as $key => $product) {
  try {
    $counter = 0;
    $title = $image = $image_save_path = $target = $price = $currency_sign = [];
    $resultsPerPage = 10;
    $nums = 0;
    $pagenum = 1;
    $maxpagenum = 1;

    $page = get_contents($product['target']);
    @$dom->loadHTML($page);

    // get the max pages number
    foreach ($dom->getElementsByTagName('div') as $div) {
      if ($div->getAttribute('class') !== 'paging-information  col-sm-4 col-sm-offset-3 col-xs-6') continue;
      preg_match('/\s(\d+)$/im', trim($div->textContent), $matches);
      $nums = trim($matches[1]);
      $maxpagenum = floor($nums / $resultsPerPage) + 1;
    }

    // get all pages data
    for ($pagenum = 1; $pagenum <= $maxpagenum; $pagenum++) {
      $url = $product['target'] . '?pagenum=' . $pagenum . '&resultsPerPage=' . $resultsPerPage;
      $page = get_contents($url);
      @$dom->loadHTML($page);
      // title, target, price, currency
      foreach ($dom->getElementsByTagName('div') as $div) {
        $class = $div->getAttribute('class');
        // title
        if ($class === 'description match-height') {
          array_push($title, trim($div->firstChild->textContent));
        }
        // target
        if ($class === 'more-information') {
          array_push($target, $site . trim($div->firstChild->getAttribute('href')));
          $counter++;
        }
        // price, currency
        if ($class === 'fh-list-price') {
          $p = trim($div->textContent);
          if ($p !== '') {
            if (preg_match('/[\d\.]+/im', $p, $match)) array_push($price, $match[0]);
            if (preg_match('/[^\d^\.]+/im', $p, $match)) array_push($currency_sign, $match[0]);
          } else {
            array_push($price, 0);
            array_push($currency_sign, '');
          }
        }
      }
      // image, image_save_path
      foreach ($dom->getElementsByTagName('a') as $a) {
        if ($a->getAttribute('class') !== 'scale-image-container img-responsive more-info') continue;
        $src = trim($a->firstChild->getAttribute('src'));
        $save_path = 'img/' . pathinfo($src)['basename'];
        array_push($image, $src ? $src : 'no image');
        array_push($image_save_path, $save_path);
      }
    }

    //*
    // product database IO
    for ($i = 0; $i < $counter; $i++) {
      $stmt = $conn->prepare('SELECT `id` FROM `products_list` WHERE `title`=? AND `target`=?'); // check record for decide update or insert
      $stmt->execute([$title[$i], $target[$i]]);
      if ($stmt->rowCount() > 0) {
        $stmt = $conn->prepare('UPDATE `products_list` SET `parent_category`=?,`title`=?,`image`=?,`image_save_path`=?,`price`=?,`currency_sign`=?,`target`=? WHERE `target`=?');
        if (!$stmt->execute([$product['title'], $title[$i], $image[$i], $image_save_path[$i], $price[$i], $currency_sign[$i], $target[$i], $target[$i]])) die('خطا حین به روزرسانی لیست محصولات - خط ' . __LINE__);
      } else {
        $stmt = $conn->prepare('INSERT INTO `products_list`(`parent_category`,`title`,`image`,`image_save_path`,`price`,`currency_sign`,`target`) VALUES(?,?,?,?,?,?,?)');
        if (!$stmt->execute([$product['title'], $title[$i], $image[$i], $image_save_path[$i], $price[$i], $currency_sign[$i], $target[$i]])) {
          dr($price[$i]);
          dr($currency_sign[$i]);
          die('خطا حین افزودن لیست محصولات به دیتابیس - خط ' . __LINE__);
        }
      }
      $record++;
    } //*/
  } catch (Exception $e) {
    continue;
  }
}
// die('Done!');
echo ('لیست محصولات با موفقیت اضافه شدند!' . '<br>');

echo ($record . ' record added to database' . '<br>');
