<?php
require_once __DIR__ . '/config.php';

$cats = $conn->query('SELECT `title`,`target` FROM `categories` ORDER BY `id` ASC')->fetchAll();

foreach ($cats as $key => $cat) {
  try {
    $counter = 0;
    $title = $description = $image = $image_save_path = $target = [];
    $page = get_contents($cat['target']);
    @$dom->loadHTML($page);
    foreach ($dom->getElementsByTagName('div') as $key => $div) {
      if (!preg_match('/match-height ft-facet fpt-tile-main/im', $div->getAttribute('class'))) continue;
      
      // title
      array_push($title, trim($div->childNodes[0]->textContent));
      
      // description
      array_push($description, trim($div->childNodes[1]->textContent));
      
      // image
      $src = trim($div->childNodes[2]->lastChild->getAttribute('src'));
      $save_path = 'img/' . pathinfo($src)['basename'];
      array_push($image, $src);
      array_push($image_save_path, $save_path);
      
      // target
      array_push($target, $site . trim($div->childNodes[3]->getAttribute('href')));
      $counter++;
    }
    
    //*
    // subcategories database IO
    for ($i = 0; $i < $counter; $i++) {
      $stmt = $conn->prepare('SELECT `id` FROM `subcategories` WHERE `title`=? AND `target`=?'); // check record for decide update or insert
      $stmt->execute([$title[$i], $target[$i]]);
      if ($stmt->rowCount() > 0) {
        $stmt = $conn->prepare('UPDATE `subcategories` SET `parent_category`=?, `title`=?, `description`=?, `image`=?, `image_save_path`=?, `target`=? WHERE `target`=?');
        if (!$stmt->execute([$cat['title'], $title[$i], $description[$i], $image[$i], $image_save_path[$i], $target[$i], $target[$i]]))
          die('خطا حین به روزرسانی زیردسته ها - خط ' . __LINE__);
      } else {
        $stmt = $conn->prepare('INSERT INTO `subcategories`(`parent_category`,`title`,`description`,`image`,`image_save_path`,`target`) VALUES(?,?,?,?,?,?)');
        if (!$stmt->execute([$cat['title'], $title[$i], $description[$i], $image[$i], $image_save_path[$i], $target[$i]]))
          die('خطا حین افزودن زیردسته ها به دیتابیس - خط ' . __LINE__);
      }
      $record++;
    } //*/
  } catch (Exception $e) {
    continue;
  }
}

echo ('زیردسته ها با موفقیت اضافه شدند!' . '<br>');

echo ($record . ' record added to database' . '<br>');